/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cmsc420project4;

/**
 *
 * @author Jeremiah
 */
public class Operator implements Node
{

    private Node leftNode;
    private Node rightNode;
    private String operation;

    Operator()
    {
    }

    Operator(String operation)
    {
	this.operation = operation;
    }

    public Node getLeft()
    {
	return leftNode;
    }

    public Node getRight()
    {
	return rightNode;
    }

    public void setLeft(Node node)
    {
	leftNode = node;
    }

    public void setRight(Node node)
    {
	rightNode = node;
    }

    public void setOperation(String operation)
    {
	this.operation = operation;
    }

    public String getOperation()
    {
	return operation;
    }
    //private

    // For the more generic case
//    public boolean isEqual(Node compare)
//    {
//        // A node is not equal to nothing.
//        if(compare == null)
//        {
//            System.out.println("Compare is null, I am " + this.printTree());
//            return false;
//        }
//
//        // A node is always equal to itself
//        if(this.hashCode() == compare.hashCode())
//        {
//            return true;
//        }
//
//        // Otherwise, we don't know - assume false.
//        return false;
//    }
    public String printTree()
    {
	String toPrint = "(";

	if (this.leftNode != null)
	{
	    toPrint = toPrint + leftNode.printTree();
	} else
	{
//            toPrint = toPrint + "{NULL}";
	}
	toPrint = toPrint + operation;
	if (this.rightNode != null)
	{
	    toPrint = toPrint + rightNode.printTree();
	} else
	{
//            toPrint = toPrint + "{NULL}";
	}
	return toPrint + ")";
    }

    public boolean isLeaf()
    {
	if (leftNode == null && rightNode == null)
	{
	    return true;
	} else
	{
	    return false;
	}
    }

    // For the sake of testing, we need to know if two trees are identical
    public boolean isEqual(Node node)
    {
	if (node instanceof Operator)
	{
	    Operator compare = (Operator)node;
	    // A node is not equal to nothing.
	    if (compare == null)
	    {
		System.out.println("(root different) Compare is null, I am " + this.printTree());
		return false;
	    }

	    // I am always identical to myself.
	    if (this.hashCode() == compare.hashCode())
	    {
		return true;
	    }


	    if (compare.getOperation().equals(operation))
	    {
		// Check null values
		if (this.leftNode == null)
		{
		    if (compare.getLeft() != null)
		    {
			System.out.println("(left node different) I am null, compare is " + compare.getLeft().printTree());
			return false;
		    }
		} else
		{
		    if (!this.leftNode.isEqual(compare.getLeft()))
		    {
			System.out.println("(left node different) I: <" + leftNode.printTree() + "> Compare: <" + compare.getLeft().printTree() + ">");
			return false;
		    }

		}

		if (this.rightNode == null)
		{
		    if (compare.getRight() != null)
		    {
			System.out.println("(right node different) I am null, compare is " + compare.getRight().printTree());
			return false;
		    }
		} else
		{
		    if (!this.rightNode.isEqual(compare.getRight()))
		    {
			System.out.println("(right node different) I: <" + rightNode.printTree() + "> Compare: <" + compare.getRight().printTree() + ">");
			return false;
		    }
		}

	    } else
	    {
		System.out.println("(root different) I: <" + operation + "> Compare: <" + compare.getOperation() + ">");
		return false;
	    }
	    return true;

	}
	System.out.println("Generic node, really of type " + node.getClass().getCanonicalName());
	if (node == null)
	{
	    System.out.println("A node is not equal to nothing.");
	    return false;
	}
	if (this.hashCode() == node.hashCode())
	{
	    return true;
	} else
	{
	    System.out.println("Generic node hash fail.");
	    return false;
	}
    }

    public String getData()
    {
	return operation;
    }
}
